/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.IVWListUpdateListener;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.security.IVWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class VWAdminRecoverUsersDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener,
ListSelectionListener,
IVWListUpdateListener,
FocusListener {
    private VWAdminResultPane m_resultsPane;
    private VWSession m_session = null;
    private Frame m_parentFrame = null;
    private JButton m_okButton = null;
    private JButton m_applyButton = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private JButton m_detailsButton = null;
    private boolean m_bCanceled = true;
    private boolean m_bLocked = false;
    private boolean m_bRecoverLogonUser = false;
    private IVWUsersAndGroupsPanel m_usersAndGroupsPanel = null;
    private JList m_queuesList = null;

    public VWAdminRecoverUsersDialog(VWAdminResultPane resultsPane) {
        super(resultsPane.getParentFrame());
        this.m_parentFrame = resultsPane.getParentFrame();
        this.m_session = resultsPane.getSession();
        this.m_resultsPane = resultsPane;
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        Dimension dim = VWStringUtils.stringToDimension("605,495");
        if (dim == null) {
            dim = new Dimension(500, 450);
        }
        this.setSize(dim.width, dim.height);
        this.setTitle(VWResource.s_recoverUsersDlgTitle);
        this.setVisible(false);
        this.setLocationRelativeTo(this.m_parentFrame);
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.disableControls();
        this.addWindowListener(new VWWindowAdapter(this));
    }

    public void removeReferences() {
        try {
            if (this.m_usersAndGroupsPanel != null) {
                this.m_usersAndGroupsPanel.removeListUpdateListener(this);
                this.m_usersAndGroupsPanel.removeReferences();
                this.m_usersAndGroupsPanel = null;
            }
            if (this.m_queuesList != null) {
                this.m_queuesList.removeListSelectionListener(this);
                this.m_queuesList = null;
            }
            super.removeReferences();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bCanceled = true;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_okButton)) {
            this.recoverUsers();
            this.m_bCanceled = false;
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_applyButton)) {
            this.recoverUsers();
            this.refreshPanel();
        } else if (event.getSource().equals(this.m_detailsButton)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DetailsDialog dlg = new DetailsDialog(this.m_parentFrame, this.getSelectedUsers(), this.getSelectedQueues());
            dlg.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (event.getSource().equals(this.m_closeButton)) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah036.htm");
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.m_queuesList)) {
            this.setControlState(false);
        }
    }

    public void listUpdated(Object source, int nEventType, Object[] items) {
        if (source.equals(this.m_usersAndGroupsPanel)) {
            switch (nEventType) {
                case 5: {
                    this.setControlState(true);
                    break;
                }
                case 6: {
                    this.setControlState(true);
                    ((VWAddRemovePanel)((Object)this.m_usersAndGroupsPanel)).getSelectedJList().requestFocus();
                }
            }
        }
    }

    protected boolean getStatus() {
        return this.m_bCanceled;
    }

    protected boolean getIsLogonUserRecovered() {
        return this.m_bRecoverLogonUser;
    }

    private JPanel createMainPanel() {
        try {
            this.m_usersAndGroupsPanel = this.m_session.getSecurityDatabaseType() == 1 ? new VWFilteredUsersPanel(this, this.m_session) : new VWUsersAndGroupsPanel(this.m_session, false);
            this.m_usersAndGroupsPanel.addListUpdateListener(this);
            String[] queueList = this.m_session.fetchQueueNames(7);
            this.m_queuesList = new JList(this.createQueueListModel(queueList));
            VWAccessibilityHelper.setAccessibility(this.m_queuesList, this, VWResource.s_selectQueues, VWResource.s_selectQueues);
            this.m_queuesList.addListSelectionListener(this);
            this.m_queuesList.addFocusListener(this);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(5, 5, 5, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 0;
            c.anchor = 23;
            c.fill = 1;
            JLabel selectUsersLabel = new JLabel(VWResource.s_selectUsers);
            selectUsersLabel.setBorder(null);
            selectUsersLabel.setFocusable(true);
            selectUsersLabel.addFocusListener(this);
            VWAccessibilityHelper.setAccessibility(selectUsersLabel, this, VWResource.s_selectUsers, VWResource.s_selectUsers);
            panel.add((Component)selectUsersLabel, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)((JPanel)((Object)this.m_usersAndGroupsPanel)), c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            JLabel selectQueuesLabel = new JLabel(VWResource.s_selectQueues);
            VWAccessibilityHelper.setAccessibility(selectQueuesLabel, this, VWResource.s_selectQueues, VWResource.s_selectQueues);
            panel.add((Component)selectQueuesLabel, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            VWAccessibilityHelper.setLabelFor(selectQueuesLabel, this.m_queuesList);
            panel.add((Component)new JScrollPane(this.m_queuesList), c);
            c.gridx = 1;
            ++c.gridy;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 22;
            c.fill = 0;
            this.m_detailsButton = new JButton(VWResource.s_detailsDots);
            this.m_detailsButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_detailsButton, this, VWResource.s_details, VWResource.s_details);
            this.m_detailsButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)this.m_detailsButton, c);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbCons = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 2, 6, 6);
            this.m_okButton = new JButton(VWResource.s_OK);
            this.m_okButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_applyButton = new JButton(VWResource.s_apply);
            this.m_applyButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_applyButton, this, VWResource.s_apply, VWResource.s_apply);
            this.m_applyButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_applyButton, gbCons);
            ++gbCons.gridx;
            this.m_closeButton = new JButton(VWResource.s_close);
            this.m_closeButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_closeButton, this, VWResource.s_close, VWResource.s_close);
            this.m_closeButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_closeButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private DefaultListModel createQueueListModel(String[] queueList) {
        VWSortedListModel queueListModel = new VWSortedListModel();
        try {
            if (this.m_session == null) {
                return queueListModel;
            }
            if (queueList != null) {
                for (int i = 0; i < queueList.length; ++i) {
                    queueListModel.addElement(queueList[i]);
                }
                queueListModel.sort();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return queueListModel;
    }

    private void disableControls() {
        this.m_queuesList.setEnabled(false);
        this.m_detailsButton.setEnabled(false);
        this.m_applyButton.setEnabled(false);
        this.m_okButton.setEnabled(false);
    }

    private void resetControls() {
        this.m_usersAndGroupsPanel.init(null);
        this.m_queuesList.clearSelection();
        this.setControlState(true);
    }

    private void setControlState(boolean bCheckUsers) {
        boolean bEnableList = false;
        boolean bEnable = false;
        if (bCheckUsers) {
            VWParticipantItem[] selectedUsers = this.m_usersAndGroupsPanel.getParticipants();
            if (selectedUsers != null && selectedUsers.length > 0) {
                bEnableList = true;
            }
            this.m_queuesList.setEnabled(bEnableList);
        } else {
            bEnableList = true;
        }
        this.updateJListFocus();
        int[] queueSelection = this.m_queuesList.getSelectedIndices();
        if (bEnableList && queueSelection != null && queueSelection.length > 0) {
            bEnable = true;
        }
        this.m_detailsButton.setEnabled(bEnable);
        this.m_applyButton.setEnabled(bEnable);
        this.m_okButton.setEnabled(bEnable);
    }

    private String[] getSelectedQueues() {
        Object[] selectedQueues = this.m_queuesList.getSelectedValues();
        if (selectedQueues == null || selectedQueues.length == 0) {
            return null;
        }
        String[] selectedQueueNames = new String[selectedQueues.length];
        for (int i = 0; i < selectedQueues.length; ++i) {
            selectedQueueNames[i] = (String)selectedQueues[i];
        }
        return selectedQueueNames;
    }

    private VWParticipantItem[] getSelectedUsers() {
        return this.m_usersAndGroupsPanel.getParticipants();
    }

    private void recoverUsers() {
        VWParticipantItem[] selectedUsers = this.getSelectedUsers();
        String[] selectedQueues = this.getSelectedQueues();
        if (selectedUsers == null || selectedUsers.length == 0 || selectedQueues == null || selectedQueues.length == 0) {
            return;
        }
        String logonUserShortName = this.m_resultsPane.getLogonUser().getParticipantName();
        String userDisplayName = null;
        for (int i = 0; i < selectedUsers.length; ++i) {
            try {
                String userShortName = selectedUsers[i].getVWParticipant().getParticipantName();
                userDisplayName = selectedUsers[i].getDisplayName();
                if (!this.m_session.recoverUser(userShortName, selectedQueues)) {
                    JOptionPane.showMessageDialog(null, VWResource.s_cannotRecoverUser + " (" + userDisplayName + ")", VWResource.s_errorMessage, 0);
                    continue;
                }
                if (!VWStringUtils.compareUsers(userShortName, logonUserShortName)) continue;
                this.m_bRecoverLogonUser = true;
                continue;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(null, ex.getLocalizedMessage() + " (" + userDisplayName + ")", VWResource.s_errorMessage, 0);
            }
        }
    }

    private void refreshPanel() {
        try {
            this.resetControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateJListFocus() {
        boolean bFocusable;
        boolean bl = bFocusable = this.m_queuesList.getModel().getSize() != 0;
        if (bFocusable != this.m_queuesList.isFocusable()) {
            this.m_queuesList.setFocusable(bFocusable);
        }
    }

    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source != null && source instanceof JList) {
            int[] indices;
            JList list = (JList)source;
            if (list.getModel().getSize() > 0 && ((indices = list.getSelectedIndices()) == null || indices.length == 0)) {
                list.setSelectedIndex(0);
            }
        } else if (source instanceof JTextField && !((JTextField)source).isEditable()) {
            ((JTextField)source).setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable()) {
            ((JTextField)source).setBorder(null);
        }
    }

    class DetailsDialog
    extends VWModalDialog
    implements IVWFrameInterface,
    ActionListener {
        private JButton m_closeButton;
        private boolean m_bCanceled;
        private JTable m_table;
        private DefaultTableModel m_tableModel;
        private VWParticipantItem[] m_selectedUsers;
        private String[] m_selectedQueues;

        public DetailsDialog(Frame parent, VWParticipantItem[] selectedUsers, String[] selectedQueues) {
            super(parent);
            this.m_closeButton = null;
            this.m_bCanceled = false;
            this.m_table = null;
            this.m_tableModel = null;
            this.m_selectedUsers = null;
            this.m_selectedQueues = null;
            try {
                this.m_selectedUsers = selectedUsers;
                this.m_selectedQueues = selectedQueues;
                this.setResizable(true);
                Dimension dim = VWStringUtils.stringToDimension("665,275");
                if (dim == null) {
                    dim = new Dimension(600, 250);
                }
                this.setSize(dim.width, dim.height);
                this.setVisible(false);
                this.setLocationRelativeTo(parent);
                this.setTitle(VWResource.s_detailsTitle);
                this.buildTable();
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().add((Component)new JScrollPane(this.m_table), "Center");
                this.getContentPane().add((Component)this.getButtonPanel(), "Last");
                Component filler = Box.createVerticalStrut(20);
                VWAccessibilityHelper.setAccessibility(filler, this, VWResource.s_detailsTitle, VWResource.s_detailsTitle);
                this.getContentPane().add(filler, "First");
                this.getContentPane().add(Box.createHorizontalStrut(20), "Before");
                this.getContentPane().add(Box.createHorizontalStrut(20), "After");
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }

        public void windowClosing(WindowEvent event) {
            super.windowClosing(event);
            this.m_bCanceled = true;
        }

        public void actionPerformed(ActionEvent event) {
            this.m_bCanceled = false;
            this.setVisible(false);
        }

        private JPanel getButtonPanel() {
            JPanel buttonPanel = new JPanel(new FlowLayout());
            this.m_closeButton = new JButton(VWResource.s_close);
            VWAccessibilityHelper.setAccessibility(this.m_closeButton, this, VWResource.s_close, VWResource.s_close);
            this.m_closeButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_closeButton.addActionListener(this);
            buttonPanel.add(this.m_closeButton);
            buttonPanel.add(Box.createHorizontalStrut(20));
            return buttonPanel;
        }

        private void buildTable() {
            Vector rowCache = new Vector();
            Vector<String> columnNames = new Vector<String>();
            columnNames.addElement(VWResource.s_lockedBy);
            columnNames.addElement(VWResource.s_queue);
            columnNames.addElement(VWResource.s_stepLabel);
            columnNames.addElement(VWResource.s_subject);
            columnNames.addElement(VWResource.s_lockTime);
            for (int i = 0; i < this.m_selectedUsers.length; ++i) {
                for (int j = 0; j < this.m_selectedQueues.length; ++j) {
                    try {
                        int flags = 3;
                        int fetchType = 1;
                        String userShortName = this.m_selectedUsers[i].getVWParticipant().getParticipantName();
                        String queryFilter = "F_LockUser = " + VWAdminRecoverUsersDialog.this.m_session.convertUserNameToId(userShortName);
                        VWQueue vwQueue = VWAdminRecoverUsersDialog.this.m_session.getQueue(this.m_selectedQueues[j]);
                        int count = vwQueue.fetchCount();
                        vwQueue.setBufferSize(count > 0 ? count : 1);
                        VWQueueQuery vwQueueQuery = vwQueue.createQuery(null, null, null, flags, queryFilter, null, fetchType);
                        while (vwQueueQuery.hasNext()) {
                            this.insertElementToVector(rowCache, (VWWorkObject)vwQueueQuery.next());
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
                    }
                }
            }
            this.m_tableModel = new DefaultTableModel(rowCache, columnNames);
            this.m_table = new VWTable(this.m_tableModel);
            this.m_table.setEnabled(false);
            this.m_table.setShowGrid(false);
            VWAccessibilityHelper.setAccessibility(this.m_table, this, VWResource.s_detailsTable, VWResource.s_detailsTable);
            this.m_table.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (DetailsDialog.this.m_table == null || DetailsDialog.this.m_table.getModel() == null || DetailsDialog.this.m_table.getRowCount() == 0) {
                        FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }
            });
        }

        private void insertElementToVector(Vector vector, VWWorkObject wob) {
            Vector<String> rowData = new Vector<String>();
            try {
                VWParticipantItem vwParticipantItem = new VWParticipantItem(wob.getLockedUserPx());
                rowData.addElement(vwParticipantItem.getDisplayName());
                rowData.addElement(wob.getCurrentQueueName());
                rowData.addElement(wob.getStepName());
                rowData.addElement(wob.getSubject());
                rowData.addElement(VWFieldsCellRenderer.toString(wob.getFieldValue("F_LockTime")));
                vector.addElement(rowData);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }
}

